#include <kernel.h>

extern "C" void kernelMain(void* multiboot_structure, uint32_t magicnumber) {
    clearScreen(); // Clear the screen upon kernel entry
    printf(combineColors(YELLOW, BLACK), "Welcome to My OS!\n");
    printf(WHITE, "Initializing GDT...\n");

    // Call the GDT initialization function
    gdt_init();

    printf(LIGHT_GREEN, "GDT initialized and loaded successfully.\n");
    printf(LIGHT_CYAN, "Transitioned to Protected Mode.\n");

    // Keep the kernel running in an infinite loop
    while (1) {
        asm volatile("hlt"); // Halt the CPU
    }
}